/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.util.ArrayList;
import java.util.Iterator;

public class ClassSelectionBean
extends PanelBean
implements LogErrorIdsLogD {
    private static final String TRACE_MASKT = "XLOGDBCT";
    private static final String TRACE_MASKF = "XLOGDBCF";
    private static final String TRACE_MASKD = "XLOGDBCD";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    public static final String BUTTON_OK = "OkButton";
    public static final String BUTTON_CANCEL = "CancelButton";
    public static final String CLASS_SELECTED = "classSelected";
    public static final int NUM_COLUMNS = 2;
    private ItemDescriptor[] m_idClassSelectionTable;
    private ColumnDescriptor[] m_cdClassSelectionTableStructure;
    private int[] m_iClassSelectionTableSelection;
    private int _numClasses;
    ArrayList _classList;
    ItemDescriptor[] _rowAt = new ItemDescriptor[2];

    public void setClassList(ArrayList classList) {
        this._classList = classList;
    }

    public ColumnDescriptor[] getClassSelectionTableRowStructure() {
        return this.m_cdClassSelectionTableStructure;
    }

    public int getClassSelectionTableRowStatus() {
        return 3;
    }

    public int getClassSelectionTableRowCount() {
        return this._numClasses;
    }

    public ItemDescriptor[] getClassSelectionTableRowAt(int index) {
        int i = 0;
        while (i < 2) {
            this._rowAt[i] = this.m_idClassSelectionTable[index * 2 + i];
            ++i;
        }
        return this._rowAt;
    }

    public void setClassSelectionTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idClassSelectionTable = items;
    }

    public int[] getClassSelectionTableSelection() {
        return this.m_iClassSelectionTableSelection;
    }

    public void setClassSelectionTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iClassSelectionTableSelection = selected;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        this.m_cdClassSelectionTableStructure = new ColumnDescriptor[0];
        this.m_iClassSelectionTableSelection = new int[0];
        int i = 0;
        while (i < 2) {
            this._rowAt[i] = new ItemDescriptor();
            ++i;
        }
        int numElements = this._classList.size();
        this._numClasses = numElements / 2;
        this.m_idClassSelectionTable = new ItemDescriptor[numElements];
        int i2 = 0;
        Iterator it = this._classList.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            this.m_idClassSelectionTable[i2] = new ItemDescriptor();
            if (obj instanceof String) {
                this.m_idClassSelectionTable[i2].setName(i2 + "logClass");
                this.m_idClassSelectionTable[i2].setTitle((String)obj);
            } else {
                this.m_idClassSelectionTable[i2].setName(i2 + "logValue");
                this.m_idClassSelectionTable[i2].setTitle(HexString.toHex((Byte)obj, true).toUpperCase());
            }
            ++i2;
        }
    }

    public void panelAction(TaskActionEvent evt) {
        Trace.trace(TRACE_MASKT, "-> ClassSelectionBean.panelAction()");
        PanelTaskletRequest request = null;
        try {
            Object fileName = null;
            UserTaskManager utm = (UserTaskManager)evt.getSource();
            utm.storeElement("ClassSelectionTable");
            String command = evt.getActionCommand();
            Trace.trace(TRACE_MASKF, "command = " + command);
            request = new PanelTaskletRequest();
            request.setData("event", evt);
            request.setData("panelName", "ClassSelectionNamePanel");
            if (command.equals(BUTTON_OK)) {
                Trace.trace(TRACE_MASKF, "Type in filename - OK button selected");
                int[] sel = this.getClassSelectionTableSelection();
                if (sel == null || sel.length == 0) {
                    Trace.trace(TRACE_MASKF, "No classes were selected.");
                    BaseMessageText myMess = new BaseMessageText("LOGDSECL");
                    LocalizableText lStrTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.file.title");
                    CommonMsgApp.showMessageBox(this.userTaskManager, lStrTitle, myMess, MsgType.INFORMATION_MESSAGE);
                } else {
                    int numSelected = sel.length;
                    Integer[] selected = new Integer[numSelected];
                    int i = 0;
                    while (i < numSelected) {
                        selected[i] = new Integer(sel[i]);
                        ++i;
                    }
                    request.setData(CLASS_SELECTED, selected);
                    this.postTaskletRequest(request);
                }
            } else {
                this.postTaskletRequest(request);
            }
            Trace.trace(TRACE_MASKT, "<- ClassSelectionBean.panelAction()");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Error caught in ClassSelectionBean.panelAction() exc = " + e);
            HException he = new HException(e);
            new FrameworkLog(_logInfo, 1305, he).log();
            request.setData("panelError", "terminate");
            this.postTaskletRequest(request);
        }
    }
}

